local function PA(x) return 0 + x end;
local function PB(x) return 32 + x end;
local function PC(x) return 64 + x end;
local function PD(x) return 96 + x end;
local function PE(x) return 128 + x end;
local function PF(x) return 160 + x end;
local function PG(x) return 192 + x end;
local function PH(x) return 224 + x end;
local function PI(x) return 256 + x end;

local function GPA(x, y) return 32*x + y end;
local function GPB(x, y) return 32*x + 8 + y end;
local function GPC(x, y) return 32*x + 16 + y end;
local function GPD(x, y) return 32*x + 24 + y end;

local boards = {
	["PERCo-STB01"] = {
		pad = {
			-- In --

			-- [0] = PE(11);	-- датчик двери
			-- [1] = PE(23);	-- кнопка ДУ
			-- [2] = PE(13);	-- вход

			-- Out --

			-- [32] = PE(5);	-- выход управления замком
			-- [33] = PF(6);	-- выход

			-- Jumpers --

			[66] = PC(1);	-- IP mode
			[67] = PC(0);	-- IP default

			-- Leds --

			[68] = PE(4);
			[69] = PE(3);

			-- RS232 reader reset --
			-- [80] = PD(0);
		};

		rs485 = "/dev/ttyS2";
		rs485_baud_rate = "115200";
		board_leds = true;
		log_archive_path = "/home/s30/";
		log_path = "/home/s30/logs/";
		db_path = "/home/s30/";
		db_path_name = "/home/s30/base.db";
		db_recovery_path_name = "/home/s30/base_rc.db";
		exdev_db_path = "/mnt/mmc/";
		exdev_db_path_name = "/mnt/mmc/exdev_base.db";
		exdev_db_recovery_path = "/mnt/mmc/exdev_base_rc.db";
		exdev_db_backup_path = "/mnt/mmc/db_backup/";
		exdev_db_backup_path_name = "/mnt/mmc/exdev_base_backup";
		exdev_db_backup_path_ext = ".db";
		max_events = "150000";
		max_events_exdev = "10000000";
	};
	
	["PERCo-CR02.9"] = {
		pad = {
			-- In --

			[0] = PE(11);	-- датчик двери
			[1] = PE(23);	-- кнопка ДУ
			[2] = PE(13);	-- вход

			-- Out --

			[32] = PE(5);	-- выход управления замком
			[33] = PF(6);	-- выход

			-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- RS232 reader reset --
			[80] = PD(0);
		};

		--led = "/dev/spidev0.1";
		rs485 = "/dev/ttyS1";
		--sound = "pwm";
		board_leds = true;
		gui = "lvgl";
		gui_subtype = "cr01";
		display_horizontal_resolution = 320;
		display_vertical_resolution = 240; --320;
	};
	
	["PERCo-CL15"] = {
		pad = {
			-- In --

			[0] = PE(6);	-- датчик двери
			[1] = PE(8);	-- кнопка ДУ
			[2] = PE(7);	-- вход

			-- Out --

			[32] = PE(5);	-- выход управления замком
			[33] = PE(10);	-- выход

			-- Jumpers --

			[66] = PE(3);	-- IP mode
			[67] = PE(4);	-- IP default

			-- Leds --

			[68] = PB(0);
			[69] = PB(1);

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[100] = PB(16);
		};

		led = "/dev/spidev1.0";
		rs232 = "/dev/ttyS2";
		sound = "sound_card";
		led_coding_3_in_4 = "no";
		-- adc = "/dev/ttyS3";

		morpho = { 0 };

		mifare = {
			pin_reset = PI(13);
			pin_irq = PI(14);
			pin_busy = PI(12);
			spi_bus = 2;
			spi_cs = 0;
		};
		board_leds = true;
		max_events = "150000";
		ind_line_interval_dynamic = "40000";
		ind_line_interval_static = "40000";
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-FL15"] = {
		pad = {
			-- In --

			[0] = GPA(1, 7);	-- PASS A
			[1] = GPB(1, 1);	-- PASS B
			[2] = GPA(1, 4);	-- DU A
			[3] = GPA(1, 6);	-- DU Stop
			[4] = GPA(1, 5);	-- DU B
			[5] = GPB(1, 0);	-- FA
			[6] = GPD(2, 5);	-- In1
			[7] = GPD(2, 6);	-- In2

			-- Out --

			[32] = GPD(2, 2);	-- выход управления замком A
			[33] = GPC(0, 1);	-- выход управления замком B
			[34] = GPC(2, 5);	-- выход 1
			[35] = GPA(0, 0);	-- выход 2

			-- Jumpers --

			[66] = GPC(1, 7);	-- IP mode
			[67] = GPC(1, 4);	-- IP default

			-- Leds --

			--[68] = GPB(2, 0);
			--[69] = GPB(2, 1);
		};

		rs485 = "/dev/ttyS4";
		rs485_2 = "/dev/ttyS3";
		sound = "sound_card";
		board_leds = true;
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CL15.1"] = {
		pad = {
			-- In --

			[0] = PE(3);	-- датчик двери
			[1] = PE(1);	-- кнопка ДУ
			[2] = PE(2);	-- вход

			-- Out --

			[32] = PE(4);	-- выход управления замком
			[33] = PE(0);	-- выход

			-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- USB Power --
			[100] = PG(5);
		};

		rs485 = "/dev/ttyS1";
		sound = "sound_card";
		morpho = { 0 };
		board_leds = true;
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CL15.3"] = {
		pad = {
			-- In --

			[0] = PE(11);	-- датчик двери
			[1] = PE(23);	-- кнопка ДУ
			[2] = PE(13);	-- вход

			-- Out --

			[32] = PE(5);	-- выход управления замком
			[33] = PF(6);	-- выход

			-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- RS232 reader reset --
			[80] = PD(0);
		};

		--led = "/dev/spidev0.1";
		rs485 = "/dev/ttyS1";
		--sound = "pwm";
		board_leds = true;
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CL15.7"] = {
		pad = {
			-- In --

			[0] = PE(11);	-- датчик двери
			[1] = PE(23);	-- кнопка ДУ
			[2] = PE(13);	-- вход

			-- Out --

			[32] = PE(5);	-- выход управления замком
			[33] = PF(6);	-- выход

			-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- RS232 reader reset --
			[80] = PD(0);

			-- USB Power --
			--[100] = PD(3);
		};

		--led = "/dev/spidev0.1";
		rs485 = "/dev/ttyS1";
		--sound = "pwm";
		board_leds = true;
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CTL14"] = {
		pad = {
			-- In --

			[0] = PH(20);	-- датчик двери 1 (1-1)
			[1] = PH(18);	-- датчик двери 2 (1-2)
			[2] = PH(16);	-- датчик двери 3 (2-1)
			[3] = PH(14);	-- датчик двери 4 (2-2)
			[4] = PH(9);	-- вход
			[5] = PH(11);	-- вход
			[6] = PH(10);	-- кнопка ДУ
			[7] = PH(8);	-- кнопка ДУ
			[8] = PH(7);	-- кнопка ДУ
			[9] = PE(5);	-- кнопка ДУ
			[10] = PE(7);	-- кнопка ДУ
			[11] = PE(9);	-- кнопка ДУ
			[12] = PH(12);	-- вход FireAlarm

			-- Out --

			[32] = PE(8);	-- выход управления ИУ
			[33] = PE(6);	-- выход управления ИУ
			[34] = PI(15);	-- выход управления ИУ
			[35] = PI(14);	-- выход управления ИУ
			[36] = PH(4);	-- выход
			[37] = PH(5);	-- выход
			[38] = PH(6);	-- выход
			[39] = PH(13);	-- выход ДУ
			[40] = PH(15);	-- выход ДУ
			[41] = PH(17);	-- выход ДУ
			[42] = PI(17);	-- выход ДУ
			[43] = PI(7);	-- выход ДУ
			[44] = PI(4);	-- выход ДУ

				-- Exdev enable output --
			[64] = PI(2);	-- exdev enable output 1
			[65] = PE(10);	-- exdev enable output 2

				-- Jumpers --

			[66] = PE(3);	-- IP mode
			[67] = PE(4);	-- IP default

			-- Leds --

			[68] = PB(0);
			[69] = PB(1);

			-- Tamper --
			[70] = PH(19);

			-- Board subtype --
			[71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			[72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[100] = PB(16);
			[101] = PB(17);
			[102] = PB(18);
		};

		led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS2";
		rs485_2 = "/dev/ttyS1";
		adc = "/dev/ttyS3";

		morpho = { 0, 1, 2 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_path_serial = {
			"/dev/serial/by-path/platform-musb-hdrc.1.auto-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c14400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1c400.usb-usb-0:1:1.0"
		};
		usb_path_input = {
			"/dev/input/by-path/platform-musb-hdrc.1.auto-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c14400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1c400.usb-usb-0:1:1.0-event-kbd"
		};
		usb_path_kbd_event = {
			"/sys/bus/usb/devices/5-1:1.0/uevent",
			"/sys/bus/usb/devices/3-1:1.0/uevent",
			"/sys/bus/usb/devices/4-1:1.0/uevent"
		};
		usb_path_dev = {
			"/sys/devices/platform/soc/1c13000.usb/musb-hdrc.1.auto/usb5/5-1",
			"/sys/devices/platform/soc/1c14400.usb/usb3/3-1",
			"/sys/devices/platform/soc/1c1c400.usb/usb4/4-1"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CTL14.1"] = {
		pad = {
			-- In --

			[0] = PE(11);	-- IN1 датчик двери 1 (1-1)
			[1] = PE(13);	-- IN2 датчик двери 2 (1-2)
			[2] = PE(15);	-- IN3 датчик двери 3 (2-1)
			[3] = PE(17);	-- IN4 датчик двери 4 (2-2)
			[4] = PE(24);	-- IN5 вход
			[5] = PE(20);	-- IN6 вход
			[6] = PE(23);	-- DU_A1 кнопка ДУ
			[7] = PG(0);	-- DU_ST1 кнопка ДУ
			[8] = PG(5);	-- DU_B1 кнопка ДУ
			[9] = PE(8);	-- DU_A2 кнопка ДУ
			[10] = PE(6);	-- DU_ST2 кнопка ДУ
			[11] = PE(4);	-- DU_B2 кнопка ДУ
			[12] = PE(19);	-- FA вход FireAlarm

			-- Out --

			[32] = PE(5);	-- L_T1 выход управления ИУ
			[33] = PE(7);	-- L_T2 выход управления ИУ
			[34] = PE(3);	-- L_T3 выход управления ИУ
			[35] = PE(2);	-- L_T4 выход управления ИУ
			[36] = PF(6);	-- OK1 выход
			[37] = PE(9);	-- OK2 выход
			[38] = PE(10);	-- OK3 выход
			[39] = PE(18);	-- PU_A выход ДУ
			[40] = PE(16);	-- PU_ST выход ДУ
			[41] = PE(14);	-- PU_B выход ДУ
			[42] = PB(2);	-- PU_A2 выход ДУ
			[43] = PC(2);	-- PU_ST2 выход ДУ
			[44] = PB(5);	-- PU_B2 выход ДУ

				-- Exdev enable output --
			[64] = PB(3);	-- EN1 exdev enable output 1
			[65] = PE(0);	-- EN2 exdev enable output 2

				-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- Tamper --
			[70] = PE(12);

			-- Board subtype --
			[71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			[72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[100] = PC(0);
			[101] = PB(17);
			[102] = PB(18);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS1";
		--rs485_2 = "/dev/ttyS1";
		adc = "/dev/ttyS2";

		morpho = { 0 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_port = {
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.1-event",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd"
		};
		usb_kbd = {
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CT13"] = {
		pad = {
			-- In --

			[0] = PH(20);	-- датчик двери 1 (1-1)
			[1] = PH(18);	-- датчик двери 2 (1-2)
			[2] = PH(16);	-- датчик двери 3 (2-1)
			[3] = PH(14);	-- датчик двери 4 (2-2)
			[4] = PH(9);	-- вход
			[5] = PH(11);	-- вход
			[6] = PH(10);	-- кнопка ДУ
			[7] = PH(8);	-- кнопка ДУ
			[8] = PH(7);	-- кнопка ДУ
			[9] = PE(5);	-- кнопка ДУ
			[10] = PE(7);	-- кнопка ДУ
			[11] = PE(9);	-- кнопка ДУ
			[12] = PH(12);	-- вход FireAlarm

			-- Out --

			[32] = PE(8);	-- выход управления ИУ
			[33] = PE(6);	-- выход управления ИУ
			[34] = PI(15);	-- выход управления ИУ
			[35] = PI(14);	-- выход управления ИУ
			[36] = PH(4);	-- выход
			[37] = PH(5);	-- выход
			[38] = PH(6);	-- выход
			[39] = PH(13);	-- выход ДУ
			[40] = PH(15);	-- выход ДУ
			[41] = PH(17);	-- выход ДУ
			[42] = PI(17);	-- выход ДУ
			[43] = PI(7);	-- выход ДУ
			[44] = PI(4);	-- выход ДУ

			-- Exdev enable output --
			[64] = PI(2);	-- exdev enable output 1
			[65] = PE(10);	-- exdev enable output 2

			-- Jumpers --

			[66] = PE(3);	-- IP mode
			[67] = PE(4);	-- IP default

			-- Leds --

			[68] = PB(0);
			[69] = PB(1);

			-- Tamper --
			[70] = PH(19);

			-- Board subtype --
			[71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			[72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[100] = PB(16);
			[101] = PB(17);
			[102] = PB(18);
		};

		led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS2";
		rs485_2 = "/dev/ttyS1";
		adc = "/dev/ttyS3";

		morpho = { 0, 1, 2 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_path_serial = {
			"/dev/serial/by-path/platform-musb-hdrc.1.auto-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c14400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1c400.usb-usb-0:1:1.0"
		};
		usb_path_input = {
			"/dev/input/by-path/platform-musb-hdrc.1.auto-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c14400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1c400.usb-usb-0:1:1.0-event-kbd"
		};
		usb_path_kbd_event = {
			"/sys/bus/usb/devices/5-1:1.0/uevent",
			"/sys/bus/usb/devices/3-1:1.0/uevent",
			"/sys/bus/usb/devices/4-1:1.0/uevent"
		};
		usb_path_dev = {
			"/sys/devices/platform/soc/1c13000.usb/musb-hdrc.1.auto/usb5/5-1",
			"/sys/devices/platform/soc/1c14400.usb/usb3/3-1",
			"/sys/devices/platform/soc/1c1c400.usb/usb4/4-1"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CT13.1"] = {
		pad = {
			-- In --

			[0] = PE(11);	-- IN1 датчик двери 1 (1-1)
			[1] = PE(13);	-- IN2 датчик двери 2 (1-2)
			[2] = PE(15);	-- IN3 датчик двери 3 (2-1)
			[3] = PE(17);	-- IN4 датчик двери 4 (2-2)
			[4] = PE(24);	-- IN5 вход
			[5] = PE(20);	-- IN6 вход
			[6] = PE(23);	-- DU_A1 кнопка ДУ
			[7] = PG(0);	-- DU_ST1 кнопка ДУ
			[8] = PG(5);	-- DU_B1 кнопка ДУ
			[9] = PE(8);	-- DU_A2 кнопка ДУ
			[10] = PE(6);	-- DU_ST2 кнопка ДУ
			[11] = PE(4);	-- DU_B2 кнопка ДУ
			[12] = PE(19);	-- FA вход FireAlarm

			-- Out --

			[32] = PE(5);	-- L_T1 выход управления ИУ
			[33] = PE(7);	-- L_T2 выход управления ИУ
			[34] = PE(3);	-- L_T3 выход управления ИУ
			[35] = PE(2);	-- L_T4 выход управления ИУ
			[36] = PF(6);	-- OK1 выход
			[37] = PE(9);	-- OK2 выход
			[38] = PE(10);	-- OK3 выход
			[39] = PE(18);	-- PU_A выход ДУ
			[40] = PE(16);	-- PU_ST выход ДУ
			[41] = PE(14);	-- PU_B выход ДУ
			[42] = PB(2);	-- PU_A2 выход ДУ
			[43] = PC(2);	-- PU_ST2 выход ДУ
			[44] = PB(5);	-- PU_B2 выход ДУ

				-- Exdev enable output --
			[64] = PB(3);	-- EN1 exdev enable output 1
			[65] = PE(0);	-- EN2 exdev enable output 2

				-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- Tamper --
			[70] = PE(12);

			-- Board subtype --
			[71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			[72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[100] = PC(0);
			[101] = PB(17);
			[102] = PB(18);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS1";
		--rs485_2 = "/dev/ttyS1";
		adc = "/dev/ttyS2";

		morpho = { 0 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_port = {
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.1-event",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd"
		};
		usb_kbd = {
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CR11"] = {
		pad = {
			-- In --

			[0] = PH(20);	-- датчик двери 1 (1-1)
			[1] = PH(18);	-- датчик двери 2 (1-2)
			[2] = PH(16);	-- датчик двери 3 (2-1)
			[3] = PH(14);	-- датчик двери 4 (2-2)
			[4] = PH(9);	-- вход
			[5] = PH(11);	-- вход
			[6] = PH(10);	-- кнопка ДУ
			[7] = PH(8);	-- кнопка ДУ
			[8] = PH(7);	-- кнопка ДУ
			[9] = PE(5);	-- кнопка ДУ
			[10] = PE(7);	-- кнопка ДУ
			[11] = PE(9);	-- кнопка ДУ
			[12] = PH(12);	-- вход FireAlarm

			-- Out --

			[32] = PE(8);	-- выход управления ИУ
			[33] = PE(6);	-- выход управления ИУ
			[34] = PI(15);	-- выход управления ИУ
			[35] = PI(14);	-- выход управления ИУ
			[36] = PH(4);	-- выход
			[37] = PH(5);	-- выход
			[38] = PH(6);	-- выход
			[39] = PH(13);	-- выход ДУ
			[40] = PH(15);	-- выход ДУ
			[41] = PH(17);	-- выход ДУ
			[42] = PI(17);	-- выход ДУ
			[43] = PI(7);	-- выход ДУ
			[44] = PI(4);	-- выход ДУ

				-- Exdev enable output --
			[64] = PI(2);	-- exdev enable output 1
			[65] = PE(10);	-- exdev enable output 2

				-- Jumpers --

			[66] = PE(3);	-- IP mode
			[67] = PE(4);	-- IP default

			-- Leds --

			[68] = PB(0);
			[69] = PB(1);

			-- Tamper --
			[70] = PH(19);

			-- Board subtype --
			[71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			[72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			[80] = PI(13);

			-- USB Power --
			[101] = PB(17);
		};

		--led = "/dev/spidev1.0";
		rs232 = "/dev/ttyS1";

		morpho = { 1 };

		mifare = {
			pin_reset = PI(13);
			pin_irq = PI(14);
			pin_busy = PI(12);
			spi_bus = 0;
			spi_cs = 0;
		};
		board_leds = true;
		sound = "sound_card";
		max_events = "150000";
		usb_path_dev = {
			"/sys/devices/platform/soc/1c13000.usb/musb-hdrc.1.auto/usb5/5-1",
			"/sys/devices/platform/soc/1c14400.usb/usb3/3-1",
			"/sys/devices/platform/soc/1c1c400.usb/usb4/4-1"
		};
	};

	["PERCo-CR11.1"] = {
		pad = {
			-- In --


			-- Out --


			-- Exdev enable output --

			-- Jumpers --

			[66] = PG(4);	-- IP mode
			[67] = PG(3);	-- IP default

			-- Leds --

			[68] = PG(2);
			[69] = PG(1);

			-- Tamper --

			-- Board subtype --

			-- So-processor readers reset --

			-- RS232 reader reset --

			-- USB Power --
			[100] = PC(2);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS1";
		sound = "sound_card";


		morpho = { 0 };

		board_leds = true;
		tamper = false;
		max_events = "150000";
		gui = "lvgl";
		backlight_fs_path = "/run/backlight/";
		light_adjust = "logarithmic";
	};

	["PERCo-CTL14.1P"] = {
		pad = {
			-- In --

			[0] = PE(6);	-- IN1 датчик двери 1 (1-1)
			[1] = PE(7);	-- IN2 датчик двери 2 (1-2)
			[2] = PE(8);	-- IN3 датчик двери 3 (2-1)
			[3] = PE(9);	-- IN4 датчик двери 4 (2-2)
			[4] = PE(3);	-- IN5 вход
			[5] = PE(11);	-- IN6 вход
			[6] = PE(2);	-- DU_A1 кнопка ДУ
			[7] = PE(12);	-- DU_ST1 кнопка ДУ
			[8] = PE(13);	-- DU_B1 кнопка ДУ
			[9] = PD(7);	-- DU_A2 кнопка ДУ
			[10] = PD(8);	-- DU_ST2 кнопка ДУ
			[11] = PD(9);	-- DU_B2 кнопка ДУ
			[12] = PE(10);	-- FA вход FireAlarm

			[13] = PC(3);	-- IN1 на плате расширения
			[14] = PD(22);	-- IN2 на плате расширения
			[15] = PC(2);	-- IN3 на плате расширения
			[16] = PD(0);	-- IN4 на плате расширения
			-- Out --

			[32] = PD(6);	-- L_T1 выход управления ИУ
			[33] = PD(5);	-- L_T2 выход управления ИУ
			[34] = PD(10);	-- L_T3 выход управления ИУ
			[35] = PD(11);	-- L_T4 выход управления ИУ
			[36] = PG(6);	-- OK1 выход
			[37] = PG(7);	-- OK2 выход
			[38] = PG(8);	-- OK3 выход
			[39] = PE(5);	-- PU_A выход ДУ
			[40] = PE(4);	-- PU_ST выход ДУ
			[41] = PE(0);	-- PU_B выход ДУ
			[42] = PD(12);	-- PU_A2 выход ДУ
			[43] = PD(16);	-- PU_ST2 выход ДУ
			[44] = PD(15);	-- PU_B2 выход ДУ

			[45] = PB(3);	-- Out1 на плате расширения
			[46] = PB(2);	-- Out2 на плате расширения
			[47] = PC(6);	-- Out3 на плате расширения
			
				-- Exdev enable output --
			-- [64] = PB(3);	-- EN1 exdev enable output 1
			-- [65] = PE(0);	-- EN2 exdev enable output 2

				-- Jumpers --

			[66] = PG(10);	-- IP mode
			[67] = PG(9);	-- IP default

			-- Leds --

			[68] = PD(3);
			[69] = PD(4);

			-- Tamper --
			[70] = PE(1);

			-- Board subtype --
			-- [71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			-- [72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			-- [80] = PI(13);

			-- USB Power --
			[100] = PD(19);
			[101] = PD(18);
			-- [102] = PB(18);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS5";
		rs485_osdp = "/dev/ttyS2";
		--rs485_2 = "/dev/ttyS1";
		adc = "/run/adc_val";
		adc_ref_v = 1.8;
		adc_bits = 12;
		adc_adj_v = {0.2, 0, 0, 0};
		adc_coeff = {11, 0, 0, 0};

		morpho = { 0, 1 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_port = {
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.1-event"
		};
		usb_kbd = {
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CTL14.2"] = {
		pad = {
			-- In --

			[0] = PE(6);	-- IN1 датчик двери 1 (1-1)
			[1] = PE(7);	-- IN2 датчик двери 2 (1-2)
			[2] = PE(8);	-- IN3 датчик двери 3 (2-1)
			[3] = PE(9);	-- IN4 датчик двери 4 (2-2)
			[4] = PE(3);	-- IN5 вход
			[5] = PE(11);	-- IN6 вход
			[6] = PE(2);	-- DU_A1 кнопка ДУ
			[7] = PE(12);	-- DU_ST1 кнопка ДУ
			[8] = PE(13);	-- DU_B1 кнопка ДУ
			[9] = PD(7);	-- DU_A2 кнопка ДУ
			[10] = PD(8);	-- DU_ST2 кнопка ДУ
			[11] = PD(9);	-- DU_B2 кнопка ДУ
			[12] = PE(10);	-- FA вход FireAlarm

			-- Out --

			[32] = PD(6);	-- L_T1 выход управления ИУ
			[33] = PD(5);	-- L_T2 выход управления ИУ
			[34] = PD(10);	-- L_T3 выход управления ИУ
			[35] = PD(11);	-- L_T4 выход управления ИУ
			[36] = PG(6);	-- OK1 выход
			[37] = PG(7);	-- OK2 выход
			[38] = PG(8);	-- OK3 выход
			[39] = PE(5);	-- PU_A выход ДУ
			[40] = PE(4);	-- PU_ST выход ДУ
			[41] = PE(0);	-- PU_B выход ДУ
			[42] = PD(12);	-- PU_A2 выход ДУ
			[43] = PD(16);	-- PU_ST2 выход ДУ
			[44] = PD(15);	-- PU_B2 выход ДУ

				-- Jumpers --

			[66] = PG(10);	-- IP mode
			[67] = PG(9);	-- IP default

			-- Leds --

			[68] = PD(3);
			[69] = PD(4);

			-- Tamper --
			[70] = PE(1);

			-- USB Power --
			[100] = PD(19);
			[101] = PD(18);
			-- [102] = PB(18);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS5";
		--rs485_2 = "/dev/ttyS1";
		adc = "/run/adc_val";
		adc_ref_v = 1.8;
		adc_bits = 12;
		adc_adj_v = {0.2, 0, 0, 0};
		adc_coeff = {11, 0, 0, 0};

		morpho = { 0, 1 };

		tamper = true;
		board_leds = true;
		max_events = "150000";
		usb_port = {
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.1-event"
		};
		usb_kbd = {
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

	["PERCo-CTL16DINP"] = {
		pad = {
			-- In --

			[0] = PD(16);	-- IN1 датчик двери 1 (1-1)
			[1] = PD(17);	-- IN2 датчик двери 2 (1-2)
			[2] = PD(10);	-- IN3 датчик двери 3 (2-1)
			[3] = PD(9);	-- IN4 датчик двери 4 (2-2)
			[4] = PD(18);	-- IN5 вход
			[5] = PD(19);	-- IN6 вход
			[6] = PG(6);	-- DU_A1 кнопка ДУ
			[7] = PG(7);	-- DU_ST1 кнопка ДУ
			[8] = PG(8);	-- DU_B1 кнопка ДУ
			[9] = PE(9);	-- DU_A2 кнопка ДУ
			[10] = PE(10);	-- DU_ST2 кнопка ДУ
			[11] = PC(7);	-- DU_B2 кнопка ДУ
			[12] = PD(5);	-- FA вход FireAlarm

			[13] = PD(8);	-- IN7
			[14] = PD(7);	-- IN8
			[15] = PD(6);	-- IN9
			-- Out --

			[32] = PD(14);	-- L_T1 выход управления ИУ
			[33] = PD(15);	-- L_T2 выход управления ИУ
			[34] = PD(12);	-- L_T3 выход управления ИУ
			[35] = PD(13);	-- L_T4 выход управления ИУ
			[36] = PE(8);	-- OK1 выход
			[37] = PE(7);	-- OK2 выход
			[38] = PE(6);	-- OK3 выход
			[39] = PC(6);	-- PU_A выход ДУ
			[40] = PC(3);	-- PU_ST выход ДУ
			[41] = PC(2);	-- PU_B выход ДУ
			[42] = PE(11);	-- PU_A2 выход ДУ
			[43] = PE(2);	-- PU_ST2 выход ДУ
			[44] = PE(3);	-- PU_B2 выход ДУ

			[45] = PE(13);	-- Out5
			[46] = PE(12);	-- Out6
			
				-- Exdev enable output --
			-- [64] = PB(3);	-- EN1 exdev enable output 1
			-- [65] = PE(0);	-- EN2 exdev enable output 2

				-- Jumpers --

			[66] = PG(10);	-- IP mode
			[67] = PG(9);	-- IP default

			-- Leds --

			[68] = PD(3);
			[69] = PD(4);

			-- Tamper --
			[70] = PE(1);

			-- Board subtype --
			-- [71] = PI(16);	-- "0" - CTL-14, "1" - СТ03

			-- So-processor readers reset --
			-- [72] = PI(9);	-- "0" - reset

			-- RS232 reader reset --
			-- [80] = PI(13);

			-- USB Power --
			[100] = PB(2);
			[101] = PB(3);
			-- [102] = PB(18);
		};

		--led = "/dev/spidev1.0";
		rs485 = "/dev/ttyS5";
		rs485_osdp = "/dev/ttyS2";
		--rs485_2 = "/dev/ttyS1";
		adc = "/run/adc_val";
		adc_ref_v = 1.8;
		adc_bits = 12;
		adc_adj_v = {0.2, 0, 0, 0};
		adc_coeff = {11, 0, 0, 0};

		morpho = { 0, 1 };

		board_leds = true;
		max_events = "150000";
		usb_port = {
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/serial/by-path/platform-1c1a400.usb-usb-0:1:1.0",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.0-event-kbd",
			"/dev/input/by-path/platform-1c1a400.usb-usb-0:1:1.1-event"
		};
		usb_kbd = {
			"/sys/bus/usb/devices/2-1:1.0/uevent",
			"/sys/bus/usb/devices/2-1:1.0/uevent"
		};
		high_speed_passage_to_tiks = 15;
		high_speed_passage_max_users = 3;
	};

}

setmetatable(boards, {__index = function (table, key) print('Lua: There is no board [' .. (key or 'NIL') .. ']') end})

BOARD = boards[product]
