-- FIREALARM

local FIREALARM			= 0x07		-- ПОЖАРНАЯ ТРЕВОГА

-- ACM

local OPENMODE 			= 0x01		-- РКД "ОТКРЫТО"
local DAYMODE 			= 0x02		-- РКД "КОНТРОЛЬ" (старое название ДНЕВНОЙ)
local GUARDMODE 		= 0x03		-- РКД "ОХРАНА"
local NIGHTMODE			= 0x04		-- РКД "ЗАКРЫТО" (старое название НОЧНОЙ)
local BUSYMODE			= 0x05		-- режим ЗАНЯТО (нет конф-и ИУ / счит-ля)
local DAMAGE			= 0x06		-- НЕИСПРАВНОСТЬ ПРИБОРА
local MASTERCARDMODE		= 0x08		-- РКД "КОНТРОЛЬ", подрежим "РЕГИСТРАЦИЯ ПОЛЬЗОВАТЕЛЕЙ"

-- ACCESS_LONG

local ACCESSPERMIT		= 0x80		-- доступ разрешён
local ACCESSOVER		= 0x81		-- доступ прекращен
local WAITCONFIRM		= 0x83		-- ожидание комиссионирования
local WAITSETGUARD		= 0x84		-- ожидание постановки ОЗ на охрану
local WAITCLRGUARD_NOZONE	= 0x85
local WAITCLRGUARD_ZONE		= 0x86
local WAITVERIFY		= 0x87		-- ожидание верификации
local WAITCLRGUARDACCESS	= 0x88
local WAITSETGUARDACCESS	= 0x89
local TAKING_ZONE		= 0x8A		-- взятие ОЗ на охрану
local NONTAKING_ZONE		= 0x8B		-- не взятие ОЗ на охрану
local WAIT_CARDCATCHER		= 0x8E		-- выключить всю индикацию на время верификации картоприёмника (индикация считывателя)
local WAITIDENTIFY_ACCESS	= 0x94		-- ожидание окончания идентификации доступа (для схем типа карта+палец, после поднесения карты)
local WAITIDENTIFY_GUARD	= 0x95		-- ожидание окончания идентификации охраны (для схем типа карта+палец, после поднесения карты)

-- ACCESS_SHORT

local ACCESSPROHIBITED		= 0x82		-- доступ запрещён
local TAKING_ZONE_2S		= 0x8C		-- взятие ОЗ на охрану
local NONTAKING_ZONE_2S		= 0x8D		-- не взятие ОЗ на охрану
local VIOLATIONCARD		= 0x8F		-- индикация для карты с нарушениями для ЛИКОН

local FINGERPRINT_TOUCH_OK	= 0x90		-- успешное промежуточное предъявление пальца
local FINGERPRINT_TOUCH_FAIL	= 0x91		-- не успешное промежуточное предъявление пальца
local FINGERPRINT_FP_OK		= 0x92		-- отпечаток зарегистрирован
local FINGERPRINT_FP_FAIL	= 0x93		-- отпечаток не зарегистрирован
local CONFIRM_OK		= 0x96		-- успешное комиссионирование (после предъявления 1-й комис-й карты для 2-го комис-я)
local VERIFY_OK			= 0x97		-- успешная верификация очередного уровня (для разделения между последовательными уровнями вериф-и)
local CARD_RECORD_OK    = 0x98		-- успешная очистка/запись отпечатков на карте
local CARD_RECORD_FAIL  = 0x99		-- не успешная очистка/запись отпечатков на карте
local IP_MODE_ON        = 0x9A      -- Перемычка IP_MODE установлена
local IP_MODE_OFF       = 0x9B      -- Перемычка IP_MODE снята
local IP_DEFAULT_ON	    = 0x9C      -- Перемычка IP_DEFAULT установлена
local IP_DEFAULT_OFF    = 0x9D      -- Перемычка IP_DEFAULT снята

INDICATION = {
    [BUSYMODE] = {
	hold = 0;
	fall = 23;
	pixmap =
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    };


    [FIREALARM] = {
	hold = 0;
	fall = 46;
	pixmap =
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!0]!!0]!!0]!'@5.'@5.!0]!!0]!!0]!" ..
        "!0]!'@5.!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "";
    };

    --

    [OPENMODE] = {
	hold = 0;
	fall = 21;
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!";
    };

    [DAYMODE] = {
	hold = 0;
	fall = 21;
	pixmap =
	    "`Q!!`Q!!`Q!!`Q!!`Q!!";
    };

    [NIGHTMODE] = {
	hold = 0;
	fall = 47;
	pixmap =
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "";
    };

    [TAKING_ZONE] = {
	hold = 0;
	fall = 119;
	pixmap =
	    "`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!" ..
        "!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!" ..
        "!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!" ..
        "!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!" ..
        "!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!" ..
        "`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!" ..
        "`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!" ..
        "!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!" ..
        "!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!" ..
        "!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!" ..
        "`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!" ..
        "`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!" ..
        "`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!" ..
        "`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!" ..
        "!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!" ..
        "`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!" ..
        "!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!`Q!!" ..
        "`Q!!`Q!!`Q!!!!!!`Q!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!" ..
        "`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!" ..
        "`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!" ..
        "!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!!!!!`Q!!`Q!!`Q!!!!!!" ..
        "!!!!`Q!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!" ..
        "!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!" ..
        "`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!" ..
        "`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!!!!!!!!!!!!!`Q!!`Q!!" ..
        "!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!" ..
        "!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!" ..
        "!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!" ..
        "!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!`Q!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    };

    [GUARDMODE] = {
	hold = 0;
	fall = 37;
	pixmap =
	"`Q!!J!-$9!!!!!!!!!!!`Q!!J!-$9!!!!!!!!!!!`Q!!J!-$9!!!!!!!!!!!J!-$" ..
    "`Q!!J!-$9!!!!!!!J!-$`Q!!J!-$9!!!!!!!J!-$`Q!!J!-$9!!!!!!!9!!!J!-$" ..
    "`Q!!J!-$9!!!9!!!J!-$`Q!!J!-$9!!!9!!!J!-$`Q!!J!-$9!!!!!!!9!!!J!-$" ..
    "`Q!!J!-$!!!!9!!!J!-$`Q!!J!-$!!!!9!!!J!-$`Q!!J!-$!!!!!!!!9!!!J!-$" ..
    "`Q!!!!!!!!!!9!!!J!-$`Q!!!!!!!!!!9!!!J!-$`Q!!!!!!!!!!!!!!9!!!J!-$" ..
    "!!!!!!!!!!!!9!!!J!-$!!!!!!!!!!!!9!!!J!-$!!!!!!!!!!!!!!!!9!!!!!!!" ..
    "!!!!!!!!!!!!9!!!!!!!!!!!!!!!!!!!9!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
    "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
    "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
    "!!!!1!%\"!!!!!!!!!!!!!!!!1!%\"!!!!!!!!!!!!!!!!1!%\"!!!!!!!!!!!!!!!!" ..
    "9!!!!!!!!!!!!!!!!!!!9!!!!!!!!!!!!!!!!!!!9!!!!!!!!!!!!!!!!!!!J!-$" ..
    "9!!!!!!!!!!!!!!!J!-$9!!!!!!!!!!!!!!!J!-$9!!!!!!!!!!!!!!!";
    };

    [MASTERCARDMODE] = {
	hold = 0;
	fall = 21;
	pixmap =
	    "````````````````````";
    };

    [WAITCONFIRM] = {
	hold = 0;
	fall = 37;
	pixmap =
	    "!\",`!R#P\"!W#!!!!!!!!!\",`!R#P\"!W#!!!!!!!!!\",`!R#P\"!W#!!!!!!!!!R#P" ..
        "!\",`!R#P\"!W#!2)\"!R#P!\",`!R#P\"!W#!\")!!R#P!\",`!R#P\"!W#!2)!\"!W#!R#P" ..
        "!\",`!R#P\"!W#\"!W#!R#P!\",`!R#P\"!W#\"!W#!R#P!\",`!R#P\"!W#!!!!\"!W#!R#P" ..
        "!\",`!R#P!!!!\"!W#!R#P!\",`!R#P!!!!\"!W#!R#P!\",`!R#P!!!!!!!!\"!W#!R#P" ..
        "!\",`!!!!!!!!\"!W#!R#P!\",`!!!!!!!!\"!W#!R#P!\",`!!!!!!!!!!!!\"!W#!R#P" ..
        "!!!!!!!!!!!!\"!W#!R#P!!!!!!!!!!!!\"!W#!R#P!!!!!!!!!!!!!!!!\"!W#!!!!" ..
        "!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!!R#P" ..
        "\"!W#!!!!!!!!!!!!!R#P\"!W#!!!!!!!!!!!!!R#P\"!W#!!!!!!!!!!!!";
    };

    [WAITVERIFY] = {
	hold = 0;
	fall = 37;
	pixmap =
	    "!\",`!R#P\"!W#!!!!!!!!!\",`!R#P\"!W#!!!!!!!!!\",`!R#P\"!W#!!!!!!!!!R#P" ..
        "!\",`!R#P\"!W#!2)\"!R#P!\",`!R#P\"!W#!\")!!R#P!\",`!R#P\"!W#!2)!\"!W#!R#P" ..
        "!\",`!R#P\"!W#\"!W#!R#P!\",`!R#P\"!W#\"!W#!R#P!\",`!R#P\"!W#!!!!\"!W#!R#P" ..
        "!\",`!R#P!!!!\"!W#!R#P!\",`!R#P!!!!\"!W#!R#P!\",`!R#P!!!!!!!!\"!W#!R#P" ..
        "!\",`!!!!!!!!\"!W#!R#P!\",`!!!!!!!!\"!W#!R#P!\",`!!!!!!!!!!!!\"!W#!R#P" ..
        "!!!!!!!!!!!!\"!W#!R#P!!!!!!!!!!!!\"!W#!R#P!!!!!!!!!!!!!!!!\"!W#!!!!" ..
        "!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!\"!W#!!!!!!!!!!!!!!!!!R#P" ..
        "\"!W#!!!!!!!!!!!!!R#P\"!W#!!!!!!!!!!!!!R#P\"!W#!!!!!!!!!!!!";
    };

    --

    [ACCESSPERMIT] = {
	hold = 0;
	fall = 37;
	pixmap =
	    "!0]\"!<U!!)=\"!!!!!!!!!0]\"!<U\"!99!!!!!!!!!!@]\"!<Q\"!9=!!!!!!!!!!<Q\"" ..
        "!@]\"!<U!!)=\"!2)\"!<U\"!0]\"!<U\"!99!!\")!!<U!!0]\"!<Q\"!9=!!2)!!9=!!<Q\"" ..
        "!@]\"!<U!!)=\"!99!!<U\"!0]\"!<U\"!99!!)=\"!<U!!0]\"!<Q\"!9=!!!!!!9=!!<Q\"" ..
        "!@]\"!<U!!!!!!99!!<U\"!0]\"!<U\"!!!!!)=\"!<U!!0]\"!<Q\"!!!!!!!!!9=!!<Q\"" ..
        "!@]\"!!!!!!!!!99!!<U\"!0]\"!!!!!!!!!)=\"!<U!!0]\"!!!!!!!!!!!!!9=!!<Q\"" ..
        "!!!!!!!!!!!!!99!!<U\"!!!!!!!!!!!!!)=\"!<U!!!!!!!!!!!!!!!!!!9=!!!!!" ..
        "!!!!!!!!!!!!!99!!!!!!!!!!!!!!!!!!)=\"!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!&A!!!!!!!!!!!!!!!!!!&A!!!!!!!!!!!!!!!!!!&A!!!!!!!!!!!!!!!!!" ..
        "!)=\"!!!!!!!!!!!!!!!!!99!!!!!!!!!!!!!!!!!!9=!!!!!!!!!!!!!!!!!!<U!" ..
        "!)=\"!!!!!!!!!!!!!<U\"!99!!!!!!!!!!!!!!<Q\"!9=!!!!!!!!!!!!!";
    };

    [ACCESSPROHIBITED] = {
	pixmap =
	    "MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!" ..
        "MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!MA!!MA!!MA!!MA!!" ..
        "MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!" ..
        "MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!MA!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    };

    [NONTAKING_ZONE_2S] = {
	pixmap =
	    "`Q!!`Q!!`Q!!`Q!!`Q!!";
    };

    [FINGERPRINT_TOUCH_OK] = {
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!";
    };

    [FINGERPRINT_TOUCH_FAIL] = {
	pixmap =
	    "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!";
    };

    [FINGERPRINT_FP_OK] = {
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    };

    [FINGERPRINT_FP_FAIL] = {
	pixmap =
	    "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ..
        "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
    };

    [CONFIRM_OK] = {
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!";
    };

    [VERIFY_OK] = {
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!";
    };

    [CARD_RECORD_OK] = {
	pixmap =
	    "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!" ..
        "!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!!0]!";
    };

    [CARD_RECORD_FAIL] = {
	pixmap =
	    "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!" ..
        "`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!`Q!!";
    };

    [WAITIDENTIFY_ACCESS] = {
	hold = 0;
	fall = 18;
	pixmap =
	    "!#U!!!!!!!!!!!!!!!!!!)A!!!!!!!!!!!!!!!!!!/%!!!%!!!!!!!!!!!!!!0]!" ..
	    "!$Y!!!!!!!!!!!!!!0]!!*E!!!!!!!!!!!!!!/E!!/Y!!!9!!!!!!!!!!*!!!0]!" ..
	    "!%]!!!!!!!!!!$-!!0]!!+I!!!!!!!!!!!!!!.5!!0=!!!Y!!!!!!!!!!(A!!0]!" ..
	    "!'!!!!!!!!!!!\"Q!!0U!!,M!!!!!!!!!!!!!!,U!!0U!!\"E!!!!!!!!!!&]!!0]!" ..
	    "!(%!!!!!!!!!!!Q!!05!!-Q!!!!!!!!!!!!!!+1!!0]!!!!!!!!!!!!!!%=!!0]!" ..
	    "!!!!!!!!!!!!!!-!!/9!!!!!!!!!!!!!!!!!!)Q!!!!!!!!!!!!!!!!!!#Y!";
    };

    [WAITIDENTIFY_GUARD] = {
	hold = 0;
	fall = 18;
	pixmap =
	    "!#U!!!!!!!!!!!!!!!!!!)A!!!!!!!!!!!!!!!!!!/%!!!%!!!!!!!!!!!!!!0]!" ..
	    "!$Y!!!!!!!!!!!!!!0]!!*E!!!!!!!!!!!!!!/E!!/Y!!!9!!!!!!!!!!*!!!0]!" ..
	    "!%]!!!!!!!!!!$-!!0]!!+I!!!!!!!!!!!!!!.5!!0=!!!Y!!!!!!!!!!(A!!0]!" ..
	    "!'!!!!!!!!!!!\"Q!!0U!!,M!!!!!!!!!!!!!!,U!!0U!!\"E!!!!!!!!!!&]!!0]!" ..
	    "!(%!!!!!!!!!!!Q!!05!!-Q!!!!!!!!!!!!!!+1!!0]!!!!!!!!!!!!!!%=!!0]!" ..
	    "!!!!!!!!!!!!!!-!!/9!!!!!!!!!!!!!!!!!!)Q!!!!!!!!!!!!!!!!!!#Y!";
    };

    [IP_MODE_ON] = {
	pixmap =
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C" ..
	    "^#0C]R8B]R$B]R8B^#0C";
    };

    [IP_MODE_OFF] = {
	pixmap =
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!" ..
	    "!!!!!!!!!!!!!!!!!!!!";
    };

    [IP_DEFAULT_ON] = {
	pixmap =
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!" ..
	    "``]!``]!``]!``]!``]!";
    };

    [IP_DEFAULT_OFF] = {
	pixmap =
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````" ..
	    "````````````````````";
    };

}

SOUND = {
    [ACCESSPERMIT] = "sound/access_permit.wav";
    [ACCESSPROHIBITED] = "sound/access_prohibited.wav";
    [NONTAKING_ZONE_2S] = "sound/access_prohibited.wav";
    [FINGERPRINT_TOUCH_OK] = "sound/3136.wav";
    [FINGERPRINT_TOUCH_FAIL] = "sound/2637.wav";
    [FINGERPRINT_FP_OK] = "sound/access_permit.wav";
    [FINGERPRINT_FP_FAIL] = "sound/access_prohibited.wav";
    [CARD_RECORD_OK] = "sound/access_permit.wav";
    [CARD_RECORD_FAIL] = "sound/access_prohibited.wav";
    [CONFIRM_OK] = "sound/3136.wav";
    [VERIFY_OK] = "sound/3136.wav";
    [IP_MODE_ON] = "sound/3136.wav";
    [IP_MODE_OFF] = "sound/2637.wav";
    [IP_DEFAULT_ON] = "sound/3136.wav";
    [IP_DEFAULT_OFF] = "sound/2637.wav";
}
