require "default"
do
  local dts_fs_model_as_file = io.open('/sys/firmware/devicetree/base/model', 'r')
  if dts_fs_model_as_file then
    local product_from_dts = dts_fs_model_as_file:read()
    if product_from_dts and product_from_dts:sub(1,5) == 'PERCo' then
      product = product_from_dts:sub(1, -2) -- truncate last character ( 0x00 )
      print('Lua: Board model [', product, '] loaded from dts')
    end
    dts_fs_model_as_file:close()
  else
    local uboot_model_as_file = io.popen("fw_printenv board_name | cut -d '=' -f 2")
    if uboot_model_as_file then
      local product_from_uboot = uboot_model_as_file:read()
      if product_from_uboot and product_from_uboot:sub(1,5) == 'PERCo' then
        product = product_from_uboot
        print('Lua: Board model [', product, '] loaded from uboot environment')
      end
      uboot_model_as_file:close()
    end
  end
end
require "version"
require "board"
require "indication"

function firstToUpper(str)
    return (str:gsub("^%l", string.upper))
end

function get_current_network_data(t)
  local pipe_from_shell = io.popen("ip rout | sed -nE 's!default via ([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9])[^0-9].*!\\1!p'")
  if pipe_from_shell then
    local gateway = pipe_from_shell:read()
    if gateway then
      t['Current gateway'] = gateway
    end
    pipe_from_shell:close()
  end
  pipe_from_shell = io.popen("cdr2mask() { set -- $(( 5 - ($1 / 8) )) 255 255 255 255 $(( (255 << (8 - ($1 % 8))) & 255 )) 0 0 0 ; [ $1 -gt 1 ] && shift $1 || shift ; echo ${1-0}.${2-0}.${3-0}.${4-0} ; } ; cdr2mask $(ip rout | sed -nE 's![0-9.]+/([0-9]+).*!\\1!p')")
  if pipe_from_shell then
    local net_mask = pipe_from_shell:read()
    if net_mask then
      t['Current netmork mask'] = net_mask
    end
    pipe_from_shell:close()
  end
  pipe_from_shell = io.popen("ip rout | sed -nE 's![0-9.]+/[0-9]+.*[^0-9]([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9])!\\1!p'")
  if pipe_from_shell then
    local cur_ip = pipe_from_shell:read()
    if cur_ip then
      t['Current IP'] = cur_ip
    end
    pipe_from_shell:close()
  end
end

sysinfo = {
    ["Product"] = product,
    ["IP default"] = ip_addr,
    ["MAC"] = mac_addr,
    ["Mask default"] = net_mask,
    ["Gateway default"] = net_gateway
}

PATH_TO_VERSION_FILES = '/var/perco/versions/'

function get_version_of(t, name)
  local f = io.open(PATH_TO_VERSION_FILES .. name)
  if f then
    t['Version of ' .. firstToUpper(name)] = f:read()
    f:close()
  end
end

--[[do
  local popen = io.popen
  local pfile = popen('ls -1 '.. PATH_TO_VERSION_FILES)
  for filename in pfile:lines() do
    get_version_of(sysinfo, filename)
  end
  pfile:close()
end--]]
for _, nm in ipairs{'image', 's30web'} do
  get_version_of(sysinfo, nm)
end
if product == 'PERCo-STB01' then
  get_version_of(sysinfo, 'stb01')
  if sysinfo['Version of Stb01'] then
    sysinfo['Version app'] = sysinfo['Version of Stb01']:gsub('[)(]+', '')
  end
else
  get_version_of(sysinfo, 's30')
  if product == 'PERCo-CR11' then
    get_version_of(sysinfo, 'licon')
  end
  if sysinfo['Version of S30'] then
    sysinfo['Version app'] = sysinfo['Version of S30']:gsub('[)(]+', '')
  end
end


function EVENT(event)
    --[[
    local moment = os.date("%x %X", os.time())
    local f = io.open("/var/www/ip_ctl.log", "a+")

    f:write(moment .. "\t".. event.event .. "\t" .. (event.id or "-") .. "\t" .. (event.number or "-") .. "\t" .. (event.direction or "-") .. "\n")
    f:close()
    ]]--
end

function SQL(event)
    if event == "ready" then
	print("Lua: SQL READY")
    end
end

function IDLE()
end

current_network_data = {}

function WEBSOCK_GET(item)
  print("Lua: WEBSOCK get " .. item)

  if item == "sysinfo" then
    return sysinfo
  elseif item == "curnetwork" then
    get_current_network_data(current_network_data)
    print("Returned network data with IP " .. current_network_data['Current IP'])
    return current_network_data
  end
end

function LEVEL(cmd, val)
    local res = 0

    if cmd == "get" then
	if val == "sysinfo" then
	    res = 0
	else
	    res = 1
	end
    elseif cmd == "set" then
	if val == "auth" then
	    res = 0
	else
	    res = 2
	end
    elseif cmd == "control" then
	res = 2
    end

    print("Lua: level " .. cmd .. " " .. val .. " = " .. res)

    return res
end

BINARY = {
    ["firmware"] = "/home/firmware.tgz",
    ["system"] = "/home/system.tgz",
    ["nand"] = "/home/nand.tgz",
    ["default"] = "/home/s30/default.lua",
    ["ssl"] = "/home/s30/ssl.pem",
    ["background"] = "/home/s30/back.png",
    ["firmware_readers"] = "/home/firmware_readers.tgz",
    ["cl211_alarm_list"] = "/home/s30/cl211_alarm_list.txt",
}

function CHECK_BINARY_BEFORE(val, size)
	print("Lua: CHECK_BINARY_BEFORE " .. val .. " file size " .. size)
	if val == "ssl" then
		if size > 100*1024 then
			print("Lua: CHECK_BINARY_BEFORE fault\n")
			return false
		end
	elseif val == "firmware" then
		if size > 512*1024*1024 then
			print("Lua: CHECK_BINARY_BEFORE fault\n")
			return false
		end
    elseif val == "firmware_readers" then
		if size > 4*1024*1024 then
			print("Lua: CHECK_BINARY_BEFORE fault\n")
			return false
		end
    elseif val == "cl211_alarm_list" then
		if size > 128*1024 then
			print("Lua: CHECK_BINARY_BEFORE fault\n")
			return false
		end
	end
	
	print("Lua: CHECK_BINARY_BEFORE success\n")
	return true
end

function CHECK_BINARY_AFTER(val)
	print("Lua: CHECK_BINARY_AFTER " .. val)
	if val == "ssl" then
	
		local marker_1 = false
		local marker_2 = false
		local marker_3 = false
		local marker_4 = false
		
		for line in io.lines("/home/s30/ssl.pem") do
			if string.find (line, "BEGIN PRIVATE KEY") then
				print("Lua: CHECK_BINARY_AFTER: marker BEGIN PRIVATE KEY found")
				marker_1 = true
			elseif string.find (line, "END PRIVATE KEY") then
				print("Lua: CHECK_BINARY_AFTER: marker END PRIVATE KEY found")
				marker_2 = true
			elseif string.find (line, "BEGIN CERTIFICATE") then
				print("Lua: CHECK_BINARY_AFTER: marker BEGIN CERTIFICATE found")
				marker_3 = true
			elseif string.find (line, "END CERTIFICATE") then
				print("Lua: CHECK_BINARY_AFTER: marker END CERTIFICATE found")
				marker_4 = true
--			else
--				print("Lua: CHECK_BINARY_AFTER: marker's not found in line: " .. line)
			end
		end
		
		if marker_1 == true  and marker_2 == true  and marker_3 == true  and marker_4 == true then
			print("Lua: CHECK_BINARY_AFTER success")
			return true
		end
		
		print("Lua: CHECK_BINARY_AFTER fault")
		return false
		
    else
    	print("Lua: CHECK_BINARY_AFTER success")
	    return true
	end
end

print("Lua: loaded")
