#!/bin/sh
CONFIG_FILE=/etc/mini-snmpd.conf
if [ "$1" = "off" ] ; then
  killall mini-snmpd
	if [ -r $CONFIG_FILE ] ; then
		mv "$CONFIG_FILE" "$CONFIG_FILE.off"
	fi
	exit
fi

locationstring=""
contactstring=""
descriptionstring="MODEL controller, version VERSION"
communitystring="public"
need_restart=""

if [ "$1" = "on" ] ; then
	if [ -r $CONFIG_FILE.off ] ; then
		mv "$CONFIG_FILE.off" "$CONFIG_FILE"
		need_restart=true
	fi
	if [ ! -r $CONFIG_FILE ] ; then
		touch "$CONFIG_FILE"
		need_restart=true
	fi
	shift
	while [ $# -gt 0 ] ; do
  	case $1 in
			-l|--location)
				locationstring="$2"
				shift # past argument
				shift # past value
				;;
			-c|--contact)
				contactstring="$2"
				shift # past argument
				shift # past value
				;;
			-d|--description)
				descriptionstring="$2"
				shift # past argument
				shift # past value
				;;
			-C|--community)
				communitystring="$2"
				shift # past argument
				shift # past value
				;;
			*)
				echo "Unknown option $1"
				exit 1
				;;
		esac
	done

	descriptionstring="$(echo "$descriptionstring" | sed "s/MODEL/$(cat /sys/firmware/devicetree/base/model)/g")"
	descriptionstring="$(echo "$descriptionstring" | sed "s/VERSION/$(cat /var/perco/versions/image | cut -f1 -d+)/g")"
#	configtext="location       = \"${locationstring}\"${NL}contact        = \"${contactstring}\"${NL}description    = \"${descriptionstring}\"${NL}community      = \"${communitystring}\"${NL}${TAIL}"
	configtext="--location \"${locationstring}\" --contact \"${contactstring}\" --description \"${descriptionstring}\" --community \"${communitystring}\" --auth --interfaces \"eth0\""

	if ! echo "$configtext" | diff -q "$CONFIG_FILE" - ; then
		echo "$configtext" > "$CONFIG_FILE"
		need_restart=true
	fi
fi

if [ -n "$need_restart" ] ; then
	killall mini-snmpd
	mini-snmpd --location "${locationstring}" --contact "${contactstring}" --description "${descriptionstring}" --community "${communitystring}" --auth --interfaces "eth0" --vendor ".1.3.6.1.4.1.64141"
fi

