(function($, dataAndEvents, auto) {
  /**
   * @return {undefined}
   */
  function loopy() {
    to = dataAndEvents[str_setTimeout](function() {
      labels.each(function() {
        var elem = $(this);
        var width = elem.width();
        var height = elem.height();
        var data = $.data(this, str_data);
        if (width !== data.w || height !== data.h) {
          elem.trigger(str_resize, [data.w = width, data.h = height]);
        }
      });
      loopy();
    }, jq_resize[str_delay]);
  }
  var labels = $([]);
  var jq_resize = $.resize = $.extend($.resize, {});
  var to;
  /** @type {string} */
  var str_setTimeout = "setTimeout";
  /** @type {string} */
  var str_resize = "resize";
  /** @type {string} */
  var str_data = str_resize + "-special-event";
  /** @type {string} */
  var str_delay = "delay";
  /** @type {string} */
  var str_throttle = "throttleWindow";
  /** @type {number} */
  jq_resize[str_delay] = 250;
  /** @type {boolean} */
  jq_resize[str_throttle] = true;
  $.event.special[str_resize] = {
    /**
     * @return {?}
     */
    setup : function() {
      if (!jq_resize[str_throttle] && this[str_setTimeout]) {
        return false;
      }
      var label = $(this);
      labels = labels.add(label);
      $.data(this, str_data, {
        w : label.width(),
        h : label.height()
      });
      if (labels.length === 1) {
        loopy();
      }
    },
    /**
     * @return {?}
     */
    teardown : function() {
      if (!jq_resize[str_throttle] && this[str_setTimeout]) {
        return false;
      }
      var label = $(this);
      labels = labels.not(label);
      label.removeData(str_data);
      if (!labels.length) {
        clearTimeout(to);
      }
    },
    /**
     * @param {Function} handleObj
     * @return {?}
     */
    add : function(handleObj) {
      /**
       * @param {?} e
       * @param {Object} w
       * @param {Object} h
       * @return {undefined}
       */
      function new_handler(e, w, h) {
        var $cont = $(this);
        var data = $.data(this, str_data);
        data.w = w !== auto ? w : $cont.width();
        data.h = h !== auto ? h : $cont.height();
        old_handler.apply(this, arguments);
      }
      if (!jq_resize[str_throttle] && this[str_setTimeout]) {
        return false;
      }
      var old_handler;
      if ($.isFunction(handleObj)) {
        /** @type {Function} */
        old_handler = handleObj;
        return new_handler;
      } else {
        old_handler = handleObj.handler;
        /** @type {function (?, Object, Object): undefined} */
        handleObj.handler = new_handler;
      }
    }
  };
})(jQuery, this);
$("body").append("<div id='jConfirm'><div style='margin-bottom: 5px;'></div><a class='jYup'></a> <a class='jNope'></a></div>");
$jConfirmDiv = $("#jConfirm");
/** @type {string} */
$jConfirmElem = "undefined";
/**
 * @return {undefined}
 */
function positionjConfirm() {
  var leftOffset;
  var meterPos;
  var propsCss;
  leftOffset = $jConfirmElem.offset().left;
  /** @type {number} */
  meterPos = $(window).width() - ($jConfirmElem.offset().left + $jConfirmElem.outerWidth());
  propsCss = $jConfirmElem.offset().top + 20;
  if (leftOffset < meterPos) {
    $jConfirmDiv.removeClass("right").css("right", "").css("left", leftOffset);
  } else {
    $jConfirmDiv.addClass("right").css("left", "").css("right", meterPos);
  }
  $jConfirmDiv.css("top", propsCss);
}
/** @type {boolean} */
$jConfirmDivOpen = false;
/**
 * @param {Object} that
 * @return {undefined}
 */
$.fn.jConfirm = function(that) {
  that = $.extend({
    message : "Are you sure?",
    confirm : "Yup",
    cancel : "Nope",
    openNow : false,
    /**
     * @param {string} _
     * @return {undefined}
     */
    callback : function(_) {
      var link = _.attr("href");
      if (typeof link !== "undefined" && link != "") {
        var isJS = link.substr(1, 11);
        if (isJS == "javascript:") {
          eval(link.replace("javascript:", ""));
        } else {
          window.location.href = link;
        }
      }
    }
  }, that);
  $this = $(this);
  $this.on("click", function(types) {
    types.preventDefault();
    /** @type {boolean} */
    $jConfirmDivOpen = true;
    $jConfirmElem = $(this);
    $jConfirmCallback = that.callback;
    var matches = $jConfirmElem.attr("href");
    $jConfirmDiv.find("div").html(that.message);
    $(".jYup").html(that.confirm);
    $(".jNope").html(that.cancel);
    positionjConfirm();
    $jConfirmDiv.slideDown("fast");
  });
  if (that.openNow) {
    /** @type {boolean} */
    $jConfirmDivOpen = true;
    $jConfirmElem = $(that.openNow);
    var matches = $jConfirmElem.attr("href");
    $jConfirmDiv.find("div").html(that.message);
    $(".jYup").html(that.confirm);
    $(".jNope").html(that.cancel);
    positionjConfirm();
    $jConfirmDiv.css("top", top).slideDown("fast");
  }
};
$jConfirmDiv.on("click", ".jYup", function(types) {
  types.preventDefault();
  $jConfirmDiv.hide();
  $jConfirmCallback($jConfirmElem);
});
$jConfirmDiv.on("click", ".jNope", function(types) {
  types.preventDefault();
  /** @type {boolean} */
  $jConfirmDivOpen = false;
  $jConfirmDiv.hide();
});
$(document).on("mouseup", function(e) {
  if ($jConfirmDivOpen) {
    if (!$jConfirmDiv.is(e.target) && $jConfirmDiv.has(e.target).length === 0) {
      $jConfirmDiv.slideUp("fast");
    }
  }
});
$("body").resize(function() {
  if ($jConfirmDivOpen) {
    positionjConfirm();
  }
});
